<?php

class Logger {
    private $configfile;

    public function __construct() {
        $t_delta = new DateInterval('PT9H');
        $now = new DateTime('now', new DateTimeZone('JST'));
        $now->add($t_delta);
        $date = $now->format('ym');
        $this->configfile = __DIR__ . "/../log/{$date}.log";
    }

    public function log($msg, $status = "INFO") {
        $t_delta = new DateInterval('PT9H');
        $now = new DateTime('now', new DateTimeZone('JST'));
        $now->add($t_delta);
        $date = $now->format('y-m-d H:i:s');
        $text = "[$date] : $status - $msg" . PHP_EOL;

        echo $text;
        file_put_contents($this->configfile, $text, FILE_APPEND | LOCK_EX);
    }
}

class RequestConfig {
    private $access_token = "";
    private $secret_token = "";
    private $domain_name = "";

    public function setAccessToken($access_token) {
        if (!$access_token) {
            throw new Exception("アクセストークンがありません");
        }
        $this->access_token = $access_token;
    }

    public function getAccessToken() {
        return $this->access_token;
    }

    public function setSecretToken($secret_token) {
        if (!$secret_token) {
            throw new Exception("シークレットトークンがありません");
        }
        $this->secret_token = $secret_token;
    }

    public function getSecretToken() {
        return $this->secret_token;
    }

    public function setDomainName($domain_name) {
        $this->domain_name = $domain_name;
    }

    public function getDomainName() {
        return $this->domain_name;
    }
}

class Config {
    private $json = [];
    private $json_datas = [];

    public function __construct() {
        $config_json = file_get_contents(__DIR__ . "/../config.json");
        $this->json = json_decode($config_json, true);
    }

    public function read() {
        $request = $this->json["request"];
        foreach ($request as $req) {
            $request_config = new RequestConfig();
            $request_config->setAccessToken($req["access_token"]);
            $request_config->setSecretToken($req["secret_token"]);
            $request_config->setDomainName($req["domain"]);
            $this->json_datas[] = $request_config;
        }
        return $this;
    }

    public function get() {
        return $this->json_datas;
    }
}

class SetIPAddr {
    private $url;

    public function __construct() {
        $this->url = 'https://dns.doliot.net/ddns/update/';
    }

    public function set($request_config) {
        $access_token = $request_config->getAccessToken();
        $secret_token = $request_config->getSecretToken();
        $domain = $request_config->getDomainName();
        
        $headers = [
            'X-SECRET-TOKEN: ' . $secret_token,
            'Content-Type: application/json'
        ];
        $data = json_encode(['use_remote_addr' => true]);

        $ch = curl_init($this->url . $access_token);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($http_code === 200) {
            return true;
        }
        return false;
    }
}

$request_ip_addrs = (new Config())->read()->get();
$log = new Logger();

foreach ($request_ip_addrs as $ip) {
    $set_ip = new SetIPAddr();
    if ($set_ip->set($ip)) {
        $log->log("Set IP Address successed for {$ip->getDomainName()}");
    } else {
        $log->log("Set IP Address invaild for {$ip->getDomainName()}", 'ERROR');
    }
    sleep(1);
}